
/****M29F002T.H Header File for M29F002T.C**************************************

   Filename:    m29f002t.h
   Description: Header file for m29f002t.c. Consult the C file for details

   Copyright (c) 1997 SGS-THOMSON Microelectronics.

   This program is provided "AS IS" WITHOUT WARRANTY OF ANY KIND,EITHER
   EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED WARRANTY
   OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK
   AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE
   PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
   REPAIR OR CORRECTION.

******************************************************************************
Commands for the various functions
******************************************************************************/

#ifndef flashprgh
#define flashprgh

#define size_t unsigned long
#define UL unsigned long

#define FLASH_READ_MANUFACTURER    (-2)
#define FLASH_READ_DEVICE_CODE     (-1)

/*******************************************************************************
Error Conditions and return values.
See end of C file for explanations and help
*******************************************************************************/
#define FLASH_BLOCK_PROTECTED      (0x01)
#define FLASH_BLOCK_UNPROTECTED    (0x00)
#define FLASH_BLOCK_NOT_ERASED     (0xFF)
#define FLASH_BLOCK_ERASE_FAILURE  (0xFE)
#define FLASH_BLOCK_ERASED         (0xFD)
#define FLASH_SUCCESS              (-1)
#define FLASH_POLL_FAIL            (-2)
#define FLASH_TOO_MANY_BLOCKS      (-3)
#define FLASH_MPU_TOO_SLOW         (-4)
#define FLASH_BLOCK_INVALID        (-5)
#define FLASH_PROGRAM_FAIL         (-6)
#define FLASH_OFFSET_OUT_OF_RANGE  (-7)
#define FLASH_WRONG_TYPE           (-8)
#define FLASH_BLOCK_FAILED_ERASE   (-9)


#define SIZEOFADDRESSEDFLASHUNIT unsigned short

#define FLASH_READSIG_OFFSET1	0x5555
#define FLASH_READSIG_OFFSET2	0x2AAA

#define FLASH_OFFSET1			FLASH_READSIG_OFFSET1
#define FLASH_PATTERN_CYCLE1	0xAA
#define FLASH_OFFSET2			FLASH_READSIG_OFFSET2
#define FLASH_PATTERN_CYCLE2	0x55
#define FLASH_PATTERN_CYCLE3	0xF0
#define FLASH_PATTERN_WRITEBLOCKERASE	0x80
#define FLASH_PATTERN_CHIPERASE	0x10
#define FLASH_PATTERN_READ_SIG	0x90
#define FLASH_PATTERN_PROGRAM	0xA0 
#define FLASH_PATTERN_ENTER_READ_MODE	0xF0
#define FLASH_PATTERN_ERASE_ADD_BLOCK 0x30
#define FLASH_PATTERN_ERASED 0xFF

#define BIT3MASK 0x0008
#define BIT7MASK 0x0080
#define BIT5MASK 0x0020  

/*******************************************************************************
Flash-type specific constants
*******************************************************************************/
#define COUNTS_PER_MICROSECOND (200)
#define BASE_ADDR ((volatile SIZEOFADDRESSEDFLASHUNIT *)0x60000000)
   /* BASE_ADDR is the base address of the flash, see the functions FlashRead
      and FlashWrite(). Some applications which require a more complicated
      FlashRead() or FlashWrite() may not use BASE_ADDR */

const unsigned long BlockOffsetConst128N[] =
{
   0x0000000L / (sizeof(short)),  /* Start offset of block 0 */
   0x0010000L / (sizeof(short)),  /* Start offset of block 1 */
   0x0020000L / (sizeof(short)),  /* Start offset of block 2 */
   0x0030000L / (sizeof(short)),  /* Start offset of block 3 */
   0x0040000L / (sizeof(short)),  /* Start offset of block 4 */
   0x0050000L / (sizeof(short)),  /* Start offset of block 5 */
   0x0060000L / (sizeof(short)),  /* Start offset of block 6 */
   0x0070000L / (sizeof(short)),  /* Start offset of block 7 */
   0x0080000L / (sizeof(short)),  /* Start offset of block 8 */
   0x0090000L / (sizeof(short)),  /* Start offset of block 9 */
   0x00A0000L / (sizeof(short)),  /* Start offset of block 10 */
   0x00B0000L / (sizeof(short)),  /* Start offset of block 11 */
   0x00C0000L / (sizeof(short)),  /* Start offset of block 12 */
   0x00D0000L / (sizeof(short)),  /* Start offset of block 13 */
   0x00E0000L / (sizeof(short)),  /* Start offset of block 14 */
   0x00F0000L / (sizeof(short)),  /* Start offset of block 15 */
   0x0100000L / (sizeof(short)),  /* Start offset of block 16 */
   0x0110000L / (sizeof(short)),  /* Start offset of block 17 */
   0x0120000L / (sizeof(short)),  /* Start offset of block 18 */
   0x0130000L / (sizeof(short)),  /* Start offset of block 19 */
   0x0140000L / (sizeof(short)),  /* Start offset of block 20 */
   0x0150000L / (sizeof(short)),  /* Start offset of block 21 */
   0x0160000L / (sizeof(short)),  /* Start offset of block 22 */
   0x0170000L / (sizeof(short)),  /* Start offset of block 23 */
   0x0180000L / (sizeof(short)),  /* Start offset of block 24 */
   0x0190000L / (sizeof(short)),  /* Start offset of block 25 */
   0x01A0000L / (sizeof(short)),  /* Start offset of block 26 */
   0x01B0000L / (sizeof(short)),  /* Start offset of block 27 */
   0x01C0000L / (sizeof(short)),  /* Start offset of block 28 */
   0x01D0000L / (sizeof(short)),  /* Start offset of block 29 */
   0x01E0000L / (sizeof(short)),  /* Start offset of block 30 */
   0x01F0000L / (sizeof(short)),  /* Start offset of block 31 */
   0x0200000L / (sizeof(short)),  /* Start offset of block 32 */
   0x0210000L / (sizeof(short)),  /* Start offset of block 33 */
   0x0220000L / (sizeof(short)),  /* Start offset of block 34 */
   0x0230000L / (sizeof(short)),  /* Start offset of block 35 */
   0x0240000L / (sizeof(short)),  /* Start offset of block 36 */
   0x0250000L / (sizeof(short)),  /* Start offset of block 37 */
   0x0260000L / (sizeof(short)),  /* Start offset of block 38 */
   0x0270000L / (sizeof(short)),  /* Start offset of block 39 */
   0x0280000L / (sizeof(short)),  /* Start offset of block 40 */
   0x0290000L / (sizeof(short)),  /* Start offset of block 41 */
   0x02A0000L / (sizeof(short)),  /* Start offset of block 42 */
   0x02B0000L / (sizeof(short)),  /* Start offset of block 43 */
   0x02C0000L / (sizeof(short)),  /* Start offset of block 44 */
   0x02D0000L / (sizeof(short)),  /* Start offset of block 45 */
   0x02E0000L / (sizeof(short)),  /* Start offset of block 46 */
   0x02F0000L / (sizeof(short)),  /* Start offset of block 47 */
   0x0300000L / (sizeof(short)),  /* Start offset of block 48 */
   0x0310000L / (sizeof(short)),  /* Start offset of block 49 */
   0x0320000L / (sizeof(short)),  /* Start offset of block 50 */
   0x0330000L / (sizeof(short)),  /* Start offset of block 51 */
   0x0340000L / (sizeof(short)),  /* Start offset of block 52 */
   0x0350000L / (sizeof(short)),  /* Start offset of block 53 */
   0x0360000L / (sizeof(short)),  /* Start offset of block 54 */
   0x0370000L / (sizeof(short)),  /* Start offset of block 55 */
   0x0380000L / (sizeof(short)),  /* Start offset of block 56 */
   0x0390000L / (sizeof(short)),  /* Start offset of block 57 */
   0x03A0000L / (sizeof(short)),  /* Start offset of block 58 */
   0x03B0000L / (sizeof(short)),  /* Start offset of block 59 */
   0x03C0000L / (sizeof(short)),  /* Start offset of block 60 */
   0x03D0000L / (sizeof(short)),  /* Start offset of block 61 */
   0x03E0000L / (sizeof(short)),  /* Start offset of block 62 */
   0x03F0000L / (sizeof(short)),  /* Start offset of block 63 */
   0x0400000L / (sizeof(short)),  /* Start offset of block 64 */
   0x0410000L / (sizeof(short)),  /* Start offset of block 65 */
   0x0420000L / (sizeof(short)),  /* Start offset of block 66 */
   0x0430000L / (sizeof(short)),  /* Start offset of block 67 */
   0x0440000L / (sizeof(short)),  /* Start offset of block 68 */
   0x0450000L / (sizeof(short)),  /* Start offset of block 69 */
   0x0460000L / (sizeof(short)),  /* Start offset of block 70 */
   0x0470000L / (sizeof(short)),  /* Start offset of block 71 */
   0x0480000L / (sizeof(short)),  /* Start offset of block 72 */
   0x0490000L / (sizeof(short)),  /* Start offset of block 73 */
   0x04A0000L / (sizeof(short)),  /* Start offset of block 74 */
   0x04B0000L / (sizeof(short)),  /* Start offset of block 75 */
   0x04C0000L / (sizeof(short)),  /* Start offset of block 76 */
   0x04D0000L / (sizeof(short)),  /* Start offset of block 77 */
   0x04E0000L / (sizeof(short)),  /* Start offset of block 78 */
   0x04F0000L / (sizeof(short)),  /* Start offset of block 79 */
   0x0500000L / (sizeof(short)),  /* Start offset of block 80 */
   0x0510000L / (sizeof(short)),  /* Start offset of block 81 */
   0x0520000L / (sizeof(short)),  /* Start offset of block 82 */
   0x0530000L / (sizeof(short)),  /* Start offset of block 83 */
   0x0540000L / (sizeof(short)),  /* Start offset of block 84 */
   0x0550000L / (sizeof(short)),  /* Start offset of block 85 */
   0x0560000L / (sizeof(short)),  /* Start offset of block 86 */
   0x0570000L / (sizeof(short)),  /* Start offset of block 87 */
   0x0580000L / (sizeof(short)),  /* Start offset of block 88 */
   0x0590000L / (sizeof(short)),  /* Start offset of block 89 */
   0x05A0000L / (sizeof(short)),  /* Start offset of block 90 */
   0x05B0000L / (sizeof(short)),  /* Start offset of block 91 */
   0x05C0000L / (sizeof(short)),  /* Start offset of block 92 */
   0x05D0000L / (sizeof(short)),  /* Start offset of block 93 */
   0x05E0000L / (sizeof(short)),  /* Start offset of block 94 */
   0x05F0000L / (sizeof(short)),  /* Start offset of block 95 */
   0x0600000L / (sizeof(short)),  /* Start offset of block 96 */
   0x0610000L / (sizeof(short)),  /* Start offset of block 97 */
   0x0620000L / (sizeof(short)),  /* Start offset of block 98 */
   0x0630000L / (sizeof(short)),  /* Start offset of block 99 */
   0x0640000L / (sizeof(short)),  /* Start offset of block 100 */
   0x0650000L / (sizeof(short)),  /* Start offset of block 101 */
   0x0660000L / (sizeof(short)),  /* Start offset of block 102 */
   0x0670000L / (sizeof(short)),  /* Start offset of block 103 */
   0x0680000L / (sizeof(short)),  /* Start offset of block 104 */
   0x0690000L / (sizeof(short)),  /* Start offset of block 105 */
   0x06A0000L / (sizeof(short)),  /* Start offset of block 106 */
   0x06B0000L / (sizeof(short)),  /* Start offset of block 107 */
   0x06C0000L / (sizeof(short)),  /* Start offset of block 108 */
   0x06D0000L / (sizeof(short)),  /* Start offset of block 109 */
   0x06E0000L / (sizeof(short)),  /* Start offset of block 110 */
   0x06F0000L / (sizeof(short)),  /* Start offset of block 111 */
   0x0700000L / (sizeof(short)),  /* Start offset of block 112 */
   0x0710000L / (sizeof(short)),  /* Start offset of block 113 */
   0x0720000L / (sizeof(short)),  /* Start offset of block 114 */
   0x0730000L / (sizeof(short)),  /* Start offset of block 115 */
   0x0740000L / (sizeof(short)),  /* Start offset of block 116 */
   0x0750000L / (sizeof(short)),  /* Start offset of block 117 */
   0x0760000L / (sizeof(short)),  /* Start offset of block 118 */
   0x0770000L / (sizeof(short)),  /* Start offset of block 119 */
   0x0780000L / (sizeof(short)),  /* Start offset of block 120 */
   0x0790000L / (sizeof(short)),  /* Start offset of block 121 */
   0x07A0000L / (sizeof(short)),  /* Start offset of block 122 */
   0x07B0000L / (sizeof(short)),  /* Start offset of block 123 */
   0x07C0000L / (sizeof(short)),  /* Start offset of block 124 */
   0x07D0000L / (sizeof(short)),  /* Start offset of block 125 */
   0x07E0000L / (sizeof(short)),  /* Start offset of block 126 */
   0x07F0000L / (sizeof(short)),  /* Start offset of block 127 */
};

/* Max of all block offset tables */
/*#define MAXBLOCKOFFSETCONSTS 8*/
/*#define MAXBLOCKOFFSETCONSTS 19*/
/*#define MAXBLOCKOFFSETCONSTS 35*/
#define MAXBLOCKOFFSETCONSTS 128

#define NUM_BLOCKS_400B (sizeof(BlockOffsetConst400B)/sizeof(BlockOffsetConst400B[0]))
#define NUM_BLOCKS_400T (sizeof(BlockOffsetConst400T)/sizeof(BlockOffsetConst400T[0]))
#define NUM_BLOCKS_800B (sizeof(BlockOffsetConst800B)/sizeof(BlockOffsetConst800B[0]))
#define NUM_BLOCKS_800T (sizeof(BlockOffsetConst800T)/sizeof(BlockOffsetConst800T[0]))
#define NUM_BLOCKS_160T (sizeof(BlockOffsetConst160T)/sizeof(BlockOffsetConst160T[0]))
#define NUM_BLOCKS_128N (sizeof(BlockOffsetConst128N)/sizeof(BlockOffsetConst128N[0]))


#define FLASH_SIZE 0x40000  

/*******************************************************************************
Function Prototypes
*******************************************************************************/
extern unsigned short FlashRead( unsigned long ulOff );
extern void FlashReadReset( void );
extern int FlashAutoSelect( int iFunc,unsigned long iNumBlocks,unsigned long *BlockOffset );
extern int FlashBlockErase( unsigned int icNumBlocks, unsigned char ucBlock[],unsigned long *BlockOffset );
extern int FlashChipErase( unsigned char *Results );
extern int FlashProgram( unsigned long Off, size_t NumBytes, void *Array );

#endif
